﻿<?php

// 設定預設速度 ★
$defaultTypeSpeedMs = 45;  // 字元出現間隔（毫秒）
$defaultLinePauseMs = 650; // 每句打完停頓（毫秒）
?>

<!doctype html>
<html lang="zh-Hant">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Typewriter Dialogue</title>
  <style>
    body { font-family: system-ui, -apple-system, "Segoe UI", Arial, sans-serif; margin: 24px; }
    #typeArea {
      white-space: pre-wrap;   /* 保留換行並自動換行 */
      line-height: 1.8;
      font-size: 18px;
      border: 1px solid #ddd;
      padding: 16px;
      border-radius: 10px;
      min-height: 180px;
    }
    .hint { margin-top: 10px; font-size: 13px; color: #666; }
  </style>
</head>
<body>

  <h2>打字機對話展示</h2>
  <div id="typeArea">載入中…</div>
  <div class="hint">（逐句接續打字；速度可調︰無游標閃爍）</div>

  <script>
    // 指定的外部檔名 ★
    const DIALOGUE_URL = "dialogue-1-1.json";

    // PHP 預設值
    const FALLBACK_TYPE_SPEED_MS = <?php echo (int)$defaultTypeSpeedMs; ?>;
    const FALLBACK_LINE_PAUSE_MS = <?php echo (int)$defaultLinePauseMs; ?>;

    const typeArea = document.getElementById("typeArea");

    function sleep(ms) {
      return new Promise(resolve => setTimeout(resolve, ms));
    }

    async function typeLine(targetEl, text, typeSpeedMs) {
      for (let i = 0; i < text.length; i++) {
        targetEl.textContent += text[i];
        await sleep(typeSpeedMs);
      }
    }

    async function runDialogue(lines, typeSpeedMs, linePauseMs) {
      typeArea.textContent = ""; // 清空「載入中…」
      for (let i = 0; i < lines.length; i++) {
        const line = String(lines[i] ?? "");
        await typeLine(typeArea, line, typeSpeedMs);

        // 每句結尾加換行（最後一句也可加）
        if (i !== lines.length - 1) {
          typeArea.textContent += "\n";
        }

        await sleep(linePauseMs);
      }
    }

    async function init() {
      try {
        const res = await fetch(DIALOGUE_URL, { cache: "no-store" });
        if (!res.ok) throw new Error("HTTP " + res.status);

        const data = await res.json();

        const lines = Array.isArray(data.lines) ? data.lines : [];
        const typeSpeedMs =
          Number.isFinite(data?.meta?.defaultTypeSpeedMs) ? data.meta.defaultTypeSpeedMs : FALLBACK_TYPE_SPEED_MS;

        const linePauseMs =
          Number.isFinite(data?.meta?.defaultLinePauseMs) ? data.meta.defaultLinePauseMs : FALLBACK_LINE_PAUSE_MS;

        if (!lines.length) {
          typeArea.textContent = "（.json 沒有提供內容）";
          return;
        }

        await runDialogue(lines, typeSpeedMs, linePauseMs);
      } catch (err) {
        typeArea.textContent = "讀取 .json 失敗：\n" + (err?.message ?? String(err));
      }
    }

    init();
  </script>

</body>
</html>
