﻿<?php
// 設定預設速度 ★
$defaultTypeSpeedMs = 50;  // 字元出現間隔（毫秒）
$defaultLinePauseMs = 650; // 每句打完停頓（毫秒）
?>
<!doctype html>
<html lang="zh-Hant">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">

  <title>Typewriter Dialogue</title>

  <style>
    body { font-family: system-ui, -apple-system, "Segoe UI", Arial, sans-serif; margin: 24px; }

    /* ★ 對話汽球外框（箭頭掛在外層，所以外層不能 overflow:hidden） */
    #typeArea{
      position: relative;
      border: 3px solid #ddd;
      padding: 16px;
      border-radius: 12px;
      background: #fff;
      box-sizing: border-box;

      overflow: visible; /* ★ 重要：讓箭頭可顯示 */
      width: fit-content;
      min-width: 360px;
      max-width: 90vw;
    }

    /* ★ 內層文字區：只顯示 2 行、超出隱藏（裁切文字，不裁切箭頭） */
    #typeText{
      position: relative;
      z-index: 2;         /* ★ 文字永遠在最上層 */
      white-space: pre-wrap;
      line-height: 1.8;
      font-size: 18px;

      height: 3.6em;      /* 2 行：1.8em * 2 */
      overflow: hidden;
    }

    /*
      ★ 長三角形箭頭：外框（灰）放在 ::before（下層）並用 rotate(-17deg) 讓尖端稍微往右指
    */
    #typeArea::before{
      content:"";
      position:absolute;
      z-index: 0;         /* ★ 外框在最底層 */
      right: 16px;
      bottom: -32px;
      width: 0;
      height: 0;

      border-style: solid;
      border-width: 36px 16px 0 16px; /* 高度36px、左右寬16px（可再加長） */
      border-color: #ddd transparent transparent transparent;

      transform: rotate(-17deg);
      transform-origin: top center;
    }

    /*
      ★ 長三角形箭頭：內填（白）放在 ::after（上層）
    */
    #typeArea::after{
      content:"";
      position:absolute;
      z-index: 1;         /* ★ 白色內填壓在外框上 */
      right: 18px;
      bottom: -28px;
      width: 0;
      height: 0;

      border-style: solid;
      border-width: 33px 13px 0 13px; /* 比外框小一圈 */
      border-color: #fff transparent transparent transparent;

      transform: rotate(-17deg);
      transform-origin: top center;
    }

    .hint { margin-top: 10px; font-size: 13px; color: #666; }
  </style>
</head>

<body bgcolor="#999999">

  <div id="typeArea"><div id="typeText">loading...</div></div>

  <!-- ★ 先輸出設定（讓外部 JS 讀得到 PHP 值） -->
  <script>
    window.TYPEWRITER_CONFIG = {
      dialogueUrl: "dialogue-KMU.json",
      fallbackTypeSpeedMs: <?php echo (int)$defaultTypeSpeedMs; ?>,
      fallbackLinePauseMs: <?php echo (int)$defaultLinePauseMs; ?>,
      maxVisibleLines: 2,
      textElementId: "typeText"
    };
  </script>

  <!-- ★ 再載入外部 JS（v=1 可防快取；改版就 v=2、v=3…） -->
  <script src="typewriter.js?v=1"></script>

</body>
</html>
